/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.utils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;

public class WSSchemaValidatorResult
implements Serializable {
    static final long serialVersionUID = -4691568558795114892L;
    private String[] m_schemaIds;
    private String m_instanceId;
    private boolean valid = true;
    private ArrayList errors = new ArrayList();

    private WSSchemaValidatorResult() {
        this.m_schemaIds = new String[]{"noValues"};
        this.m_instanceId = "noValue";
    }

    public boolean getValid() {
        return this.valid;
    }

    public WSSchemaValidatorResult(String[] schemaIds, String instanceId) {
        this.m_schemaIds = schemaIds;
        this.m_instanceId = instanceId;
    }

    public String[] getErrors() {
        return this.errors.toArray(new String[0]);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("\nSchema Validator Result: for ");
        buf.append(this.m_instanceId);
        buf.append("\nSchema Ids=");
        for (int i = 0; i < this.m_schemaIds.length; ++i) {
            buf.append(this.m_schemaIds[i]).append("\n");
        }
        buf.append("IS ");
        if (this.valid) {
            buf.append("VALID.\n");
        } else {
            buf.append("INVALID.  Errors: ");
            Iterator iter = this.errors.iterator();
            if (iter != null) {
                int i = 0;
                while (iter.hasNext()) {
                    buf.append(i).append(" : ").append(iter.next()).append("\n");
                    ++i;
                }
            }
        }
        return buf.toString();
    }

    protected void setValid(boolean b) {
        this.valid = b;
    }

    protected void addError(String s) {
        this.errors.add(s);
    }
}

